//
//  DHDSockAddress.h
//  DHDMX
//
//  Created by Douglas Heriot on 30/06/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <netinet/in.h>
#import <netinet6/in6.h>

// Abstract superclass - will always return specific IPv4/6 subclasses instead
@interface DHDSockAddress : NSData

- (id)initWithSockAddr:(struct sockaddr *)addr;
+ (DHDSockAddress *)sockAddressWithSockAddr:(struct sockaddr *)addr;
+ (DHDSockAddress *)sockAddressWithData:(NSData *)data;

@property (readonly) const struct sockaddr *sockaddr;
@property (readonly) sa_family_t family;
@property (readonly) NSString *addressString;

@property (readonly) NSData *data;

@end


@interface DHDSockAddressIPv4 : DHDSockAddress
{
	struct sockaddr_in _addr;
}

- (id)initWithSockAddrIn:(struct sockaddr_in *)addr;
+ (DHDSockAddressIPv4 *)sockAddressWithSockAddrIn:(struct sockaddr_in *)addr;

+ (DHDSockAddressIPv4 *)sockAddressWithAddress:(struct in_addr)address port:(in_addr_t)port;
+ (DHDSockAddressIPv4 *)sockAddressWithAddressString:(NSString *)addressString port:(in_port_t)port;

+ (struct in_addr)addressWithString:(NSString *)addressString error:(NSError *__autoreleasing *)error;

@property (readonly) const struct sockaddr_in *sockaddr_in;
@property (readonly) in_port_t port; // converted to host byte order

@property (readonly) struct in_addr addressStruct;
@property (readonly) const struct in_addr *addressPointer;
@property (readonly) in_addr_t addressNumber;

@end


@interface DHDSockAddressIPv6 : DHDSockAddress
{
	struct sockaddr_in6 _addr;
}

- (id)initWithSockAddrIn6:(struct sockaddr_in6 *)addr;
+ (DHDSockAddressIPv6 *)sockAddressWithSockAddrIn6:(struct sockaddr_in6 *)addr;

// TODO: create factory methods

+ (struct in6_addr)addressWithString:(NSString *)addressString error:(NSError *__autoreleasing *)error;

@property (readonly) const struct sockaddr_in6 *sockaddr_in6;
@property (readonly) in_port_t port; // converted to host byte order

@property (readonly) struct in6_addr addressStruct;
@property (readonly) const struct in6_addr *addressPointer;

@property (readonly) uint32_t flowinfo;
@property (readonly) uint32_t scope;

@end

